
***********************************
******* LFK alpha version 1 *******
***********************************

***
program define lfk, rclass
syntax varlist(min=1 max=4 numeric) [if] [in], [rr or]

tempvar a
marksample touse, novarlist 
if "`a'" == "" markout `touse'
capture drop _lfk
preserve
quietly keep if `touse'

** Binary data input + OR
if "`3'" != "" & "`4'" != "" & "`or'" !=""{
	display ""
	display ""
	display "Data input format tcases tnoncases ccases cnoncases assumed"
	display "OR selected"  

	quietly{
	gen __a = `1'
	gen __b = `2'
	gen __c = `3'
	gen __d = `4'
	
	replace __a = __a+0.5 if __a==0 | __b==0 | __c==0 | __d==0
	replace __b = __b+0.5 if __a==0 | __b==0 | __c==0 | __d==0
	replace __c = __c+0.5 if __a==0 | __b==0 | __c==0 | __d==0
	replace __d = __d+0.5 if __a==0 | __b==0 | __c==0 | __d==0

	gen __ES = ln((__a*__d)/(__b*__c))
	gen __seES = sqrt((1/__a)+(1/__b)+(1/__c)+(1/__d))

	bysort __ES __seES: gen __dup = cond(_N==1,1,_n) 
	gsort -__dup __ES
	gen __dup_max = __dup[1] 
	sort __ES __dup
	gen __seES2 = __seES^2 
	egen __seES2max = max(__seES2) 
	gen __n = round(((__seES2max/__seES2)*100),1) 
	gen __rank1 = sum(__n) if __dup ==1 
	replace __rank1 = __rank1[_n-1] if __rank1==.  
	gen __pct1 = __rank1[_n-__dup_max] 
	replace __pct1 = 0 if __pct1 ==. 
	gen __rank2 = (__rank1 + __pct1)/2 
	egen __n_sum = sum(__n) if __dup==1 				
	replace __n_sum = __n_sum[_n-1] if __n_sum==. 		
	gen __i = (__rank2-0.5)/__n_sum 
	gen __z = invnorm(__i)  	
	gen __z_abs = abs(invnorm(__i)) 
	sort __z_abs 
	gen __es_z_min = __ES[1] 
	gen __es_dif = __ES - __es_z_min 
	sort __z 
	gen __z_min = __z[1] 
	gen __z_max = __z[_N] 
	sort __es_dif 
	gen __es_dif_min = __es_dif[1] 
	gen __es_dif_max = __es_dif[_N] 
	gen __r = (__z_max-__z_min) / (__es_dif_max-__es_dif_min) 
	gen __r2 = __z + (__r*(__es_dif)) 
	egen __r2_sum = sum(__r2) 
	gen __lfk = (5/(2*_N)) * (__r2_sum) 
	scalar define lfk = __lfk[1]
	}
	
	display ""
	display ""
	display "LFK index"
	display ""
	display __lfk

	local es_z_min_1 = __es_z_min[1]
	local lfk_1 = round(__lfk[1],0.01)
	twoway (connected __z_abs __ES, xline(`es_z_min_1', lcolor(black) noextend) mcolor(black) msize(vlarge) msymbol(circle) mfcolor(white) lcolor(black) lpattern(shortdash)), title(LFK index = `lfk_1', size(medsmall) margin(medium)) ytitle(| Z-score |) ytitle(, size(large)) yscale(reverse) ylabel(, labsize(large) angle(horizontal) labgap(small) nogrid) xtitle(LnOR) xtitle(, size(large)) xlabel(, labsize(large) labgap(small)) aspectratio(1.3) graphregion(fcolor(white))
}
*

** Binary data input + OR (assumed)
if "`3'" != "" & "`4'" != "" & "`or'" =="" & "`rr'" ==""{
	display ""
	display ""
	display "Data input format tcases tnoncases ccases cnoncases assumed"
	display "OR assumed"  

	quietly{
	gen __a = `1'
	gen __b = `2'
	gen __c = `3'
	gen __d = `4'

	replace __a = __a+0.5 if __a==0 | __b==0 | __c==0 | __d==0
	replace __b = __b+0.5 if __a==0 | __b==0 | __c==0 | __d==0
	replace __c = __c+0.5 if __a==0 | __b==0 | __c==0 | __d==0
	replace __d = __d+0.5 if __a==0 | __b==0 | __c==0 | __d==0
	
	gen __ES = ln((__a*__d)/(__b*__c))
	gen __seES = sqrt((1/__a)+(1/__b)+(1/__c)+(1/__d))

	bysort __ES __seES: gen __dup = cond(_N==1,1,_n) 
	gsort -__dup __ES
	gen __dup_max = __dup[1] 
	sort __ES __dup
	gen __seES2 = __seES^2 
	egen __seES2max = max(__seES2) 
	gen __n = round(((__seES2max/__seES2)*100),1) 
	gen __rank1 = sum(__n) if __dup ==1 
	replace __rank1 = __rank1[_n-1] if __rank1==.  
	gen __pct1 = __rank1[_n-__dup_max] 
	replace __pct1 = 0 if __pct1 ==. 
	gen __rank2 = (__rank1 + __pct1)/2 
	egen __n_sum = sum(__n) if __dup==1 				
	replace __n_sum = __n_sum[_n-1] if __n_sum==. 		
	gen __i = (__rank2-0.5)/__n_sum 
	gen __z = invnorm(__i)  	
	gen __z_abs = abs(invnorm(__i)) 
	sort __z_abs 
	gen __es_z_min = __ES[1] 
	gen __es_dif = __ES - __es_z_min 
	sort __z 
	gen __z_min = __z[1] 
	gen __z_max = __z[_N] 
	sort __es_dif 
	gen __es_dif_min = __es_dif[1] 
	gen __es_dif_max = __es_dif[_N] 
	gen __r = (__z_max-__z_min) / (__es_dif_max-__es_dif_min) 
	gen __r2 = __z + (__r*(__es_dif)) 
	egen __r2_sum = sum(__r2) 
	gen __lfk = (5/(2*_N)) * (__r2_sum) 
	scalar define lfk = __lfk[1]
	}
	
	display ""
	display ""
	display "LFK index"
	display ""
	display __lfk

	local es_z_min_1 = __es_z_min[1]
	local lfk_1 = round(__lfk[1],0.01)
	twoway (connected __z_abs __ES, xline(`es_z_min_1', lcolor(black) noextend) mcolor(black) msize(vlarge) msymbol(circle) mfcolor(white) lcolor(black) lpattern(shortdash)), title(LFK index = `lfk_1', size(medsmall) margin(medium)) ytitle(| Z-score |) ytitle(, size(large)) yscale(reverse) ylabel(, labsize(large) angle(horizontal) labgap(small) nogrid) xtitle(LnOR) xtitle(, size(large)) xlabel(, labsize(large) labgap(small)) aspectratio(1.3) graphregion(fcolor(white))
}
*

** Binary data input + RR
if "`3'" != "" & "`4'" != "" & "`rr'" !=""{
	display ""
	display ""
	display "Data input format tcases tnoncases ccases cnoncases assumed"
	display "RR selected" 
	
	quietly{
	gen __a = `1'
	gen __b = `2'
	gen __c = `3'
	gen __d = `4'
	
	replace __a = __a+0.5 if __a==0 | __b==0 | __c==0 | __d==0
	replace __b = __b+0.5 if __a==0 | __b==0 | __c==0 | __d==0
	replace __c = __c+0.5 if __a==0 | __b==0 | __c==0 | __d==0
	replace __d = __d+0.5 if __a==0 | __b==0 | __c==0 | __d==0
	
	gen __ES = ln((__a/(__a+__b))/(__c/(__c+__d)))
	gen __seES = sqrt((1/__a)+(1/__c)-(1/(__a+__b))-(1/(__c+__d)))

	bysort __ES __seES: gen __dup = cond(_N==1,1,_n) 
	gsort -__dup __ES
	gen __dup_max = __dup[1] 
	sort __ES __dup
	gen __seES2 = __seES^2 
	egen __seES2max = max(__seES2) 
	gen __n = round(((__seES2max/__seES2)*100),1) 
	gen __rank1 = sum(__n) if __dup ==1 
	replace __rank1 = __rank1[_n-1] if __rank1==.  
	gen __pct1 = __rank1[_n-__dup_max] 
	replace __pct1 = 0 if __pct1 ==. 
	gen __rank2 = (__rank1 + __pct1)/2 
	egen __n_sum = sum(__n) if __dup==1 				
	replace __n_sum = __n_sum[_n-1] if __n_sum==. 		
	gen __i = (__rank2-0.5)/__n_sum 
	gen __z = invnorm(__i)  	
	gen __z_abs = abs(invnorm(__i)) 
	sort __z_abs 
	gen __es_z_min = __ES[1] 
	gen __es_dif = __ES - __es_z_min 
	sort __z 
	gen __z_min = __z[1] 
	gen __z_max = __z[_N] 
	sort __es_dif 
	gen __es_dif_min = __es_dif[1] 
	gen __es_dif_max = __es_dif[_N] 
	gen __r = (__z_max-__z_min) / (__es_dif_max-__es_dif_min) 
	gen __r2 = __z + (__r*(__es_dif)) 
	egen __r2_sum = sum(__r2) 
	gen __lfk = (5/(2*_N)) * (__r2_sum) 
	scalar define lfk = __lfk[1]
	}
	
	display ""
	display ""
	display "LFK index"
	display ""
	display __lfk

	local es_z_min_1 = __es_z_min[1]
	local lfk_1 = round(__lfk[1],0.01)
	twoway (connected __z_abs __ES, xline(`es_z_min_1', lcolor(black) noextend) mcolor(black) msize(vlarge) msymbol(circle) mfcolor(white) lcolor(black) lpattern(shortdash)), title(LFK index = `lfk_1', size(medsmall) margin(medium)) ytitle(| Z-score |) ytitle(, size(large)) yscale(reverse) ylabel(, labsize(large) angle(horizontal) labgap(small) nogrid) xtitle(LnRR) xtitle(, size(large)) xlabel(, labsize(large) labgap(small)) aspectratio(1.3) graphregion(fcolor(white))
}
*

** Theta SE_Theta
if "`3'" == "" & "`4'" == "" & "`rr'" == "" & "`or'" == ""{
	display ""
	display ""
	display "Data input format theta se_theta assumed"

	quietly{
	gen __ES = `1'
	gen __seES = `2'
	
	bysort __ES __seES: gen __dup = cond(_N==1,1,_n) 
	gsort -__dup __ES
	gen __dup_max = __dup[1] 
	sort __ES __dup
	gen __seES2 = __seES^2 
	egen __seES2max = max(__seES2) 
	gen __n = round(((__seES2max/__seES2)*100),1) 
	gen __rank1 = sum(__n) if __dup ==1 
	replace __rank1 = __rank1[_n-1] if __rank1==.  
	gen __pct1 = __rank1[_n-__dup_max] 
	replace __pct1 = 0 if __pct1 ==. 
	gen __rank2 = (__rank1 + __pct1)/2 
	egen __n_sum = sum(__n) if __dup==1 				
	replace __n_sum = __n_sum[_n-1] if __n_sum==. 		
	gen __i = (__rank2-0.5)/__n_sum 
	gen __z = invnorm(__i)  	
	gen __z_abs = abs(invnorm(__i)) 
	sort __z_abs 
	gen __es_z_min = __ES[1] 
	gen __es_dif = __ES - __es_z_min 
	sort __z 
	gen __z_min = __z[1] 
	gen __z_max = __z[_N] 
	sort __es_dif 
	gen __es_dif_min = __es_dif[1] 
	gen __es_dif_max = __es_dif[_N] 
	gen __r = (__z_max-__z_min) / (__es_dif_max-__es_dif_min) 
	gen __r2 = __z + (__r*(__es_dif)) 
	egen __r2_sum = sum(__r2) 
	gen __lfk = (5/(2*_N)) * (__r2_sum) 
	scalar define lfk = __lfk[1]
	}
	
	display ""
	display ""
	display "LFK index"
	display ""
	display __lfk

	local es_z_min_1 = __es_z_min[1]
	local lfk_1 = round(__lfk[1],0.01)
	twoway (connected __z_abs __ES, xline(`es_z_min_1', lcolor(black) noextend) mcolor(black) msize(vlarge) msymbol(circle) mfcolor(white) lcolor(black) lpattern(shortdash)), title(LFK index = `lfk_1', size(medsmall) margin(medium)) ytitle(| Z-score |) ytitle(, size(large)) yscale(reverse) ylabel(, labsize(large) angle(horizontal) labgap(small) nogrid) xtitle(ES) xtitle(, size(large)) xlabel(, labsize(large) labgap(small)) aspectratio(1.3) graphregion(fcolor(white))
}
*

restore 
quietly gen _lfk = lfk if `touse' ==1

end




/**********************
For next versions add:
	- option no graph
	- data input error 
	- help menu
**********************/






